﻿uses GraphABC;

procedure DrawCleanParabola();
var
  x0, y0, scale: integer;
  
  function f(x: real): real;
  begin
    Result := (x*x)/64 - x + 12;
  end;
  
begin
  Window.Title := 'Индийские обезьяны 2 граф';
  Window.SetSize(640, 420);
  
  Brush.Color := Color.White;
  FillRectangle(0, 0, Window.Width, Window.Height);
  
  x0 := 100;
  y0 := 300;
  scale := 8;
  
  // Ось X
  Pen.Color := Color.Black;
  Pen.Width := 2;
  Line(50, y0, 650, y0);
  
  // Отметки на оси X
  for var i := 0 to 70 do
    if i mod 2 = 0 then
    begin
      var xpos := x0 + i * scale;
      Line(xpos, y0 - 3, xpos, y0 + 3);
      if (i = 16) or (i = 48) then
      begin
        Font.Color := Color.Red;
        TextOut(xpos - 5, y0 + 8, i.ToString);
      end
      else
      begin
        Font.Color := Color.Black;
        TextOut(xpos - 5, y0 + 8, i.ToString);
      end;
    end;
  
  // Ось Y
  Line(x0, 50, x0, 350);
  
  // Парабола
  Pen.Color := Color.Blue;
  Pen.Width := 3;
  
  var first := true;
  for var x := 0 to 65 step 1 do
  begin
    var y := f(x);
    var xpos := x0 + x * scale;
    var ypos := Round(y0 - y * scale * 2);
    
    if (ypos < -50) or (ypos > 500) then continue;
    
    if first then
    begin
      MoveTo(xpos, ypos);
      first := false;
    end
    else
      LineTo(xpos, ypos);
  end;
  
  // Корни
  Pen.Color := Color.Red;
  Brush.Color := Color.Red;
  
  var roots := Arr(16, 48);
  foreach var root in roots do
  begin
    var y := f(root);
    var xpos := x0 + root * scale;
    var ypos := y0 - Round(y * scale);
    
    Circle(xpos, ypos, 5);
    
    // Вертикальная линия к оси X
    Pen.Color := Color.Gray;
    Pen.Style := psDash;
    Line(xpos, ypos, xpos, y0);
    Pen.Style := psSolid;
    Pen.Color := Color.Red;
  end;
end;


begin
  DrawCleanParabola();
end.